<?php 
header("Content-Type: application/json");
require 'db_config.php';

$name = $_POST['name'] ?? '';
$description = $_POST['description'] ?? null;
$location = $_POST['location'] ?? null;
$status = $_POST['status'] ?? '';
$imageUrl = $_POST['imageUrl'] ?? null;   // IMPORTANT: Cloudinary URL
$userId = $_POST['userId'] ?? '';

$category = $_POST['category'] ?? null;
$contactPhone = $_POST['contactPhone'] ?? null;
$contactEmail = $_POST['contactEmail'] ?? null;

// Required fields
if (empty($name) || empty($status) || empty($userId)) {
    echo json_encode([
        "status" => "error",
        "message" => "Missing required fields"
    ]);
    exit();
}

$stmt = $conn->prepare("
    INSERT INTO items 
    (name, description, location, imageUrl, status, userId, category, contactPhone, contactEmail)
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)
");

$stmt->bind_param(
    "sssssssss",
    $name,
    $description,
    $location,
    $imageUrl,       // <--- Store Cloudinary URL
    $status,
    $userId,
    $category,
    $contactPhone,
    $contactEmail
);

if ($stmt->execute()) {
    echo json_encode(["status" => "success"]);
} else {
    echo json_encode(["status" => "error", "message" => $stmt->error]);
}

$stmt->close();
$conn->close();
?>
