<?php
header("Content-Type: application/json");
require 'db_config.php';

$email = $_POST['email'] ?? $_GET['email'] ?? '';
$password = $_POST['password'] ?? $_GET['password'] ?? '';

if (empty($email) || empty($password)) {
    echo json_encode(["status" => "error", "message" => "Email and password required"]);
    exit();
}

$stmt = $conn->prepare("SELECT id, uid, password FROM users WHERE email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();

if ($user = $result->fetch_assoc()) {

    if (password_verify($password, $user['password'])) {

        // UID is empty → generate a new unique UID
        if (empty($user['uid'])) {

            $newUid = uniqid("u_", true);

            $update = $conn->prepare("UPDATE users SET uid = ? WHERE id = ?");
            $update->bind_param("si", $newUid, $user['id']);
            $update->execute();
            $update->close();

            echo json_encode(["status" => "success", "uid" => $newUid]);
            exit();
        }

        echo json_encode(["status" => "success", "uid" => $user['uid']]);

    } else {
        echo json_encode(["status" => "error", "message" => "Invalid credentials"]);
    }

} else {
    echo json_encode(["status" => "error", "message" => "User not found"]);
}

$stmt->close();
$conn->close();
?>
