<?php 
header("Content-Type: application/json");
require 'db_config.php';

$name = $_POST['name'] ?? '';
$collegeId = $_POST['collegeId'] ?? '';
$email = $_POST['email'] ?? '';
$password = $_POST['password'] ?? '';

if (empty($name) || empty($collegeId) || empty($email) || empty($password)) {
    echo json_encode(["status" => "error", "message" => "Missing required fields"]);
    exit();
}

// CHECK IF USER ALREADY EXISTS
$check = $conn->prepare("SELECT uid FROM users WHERE email = ?");
$check->bind_param("s", $email);
$check->execute();
$res = $check->get_result();

if ($res->num_rows > 0) {
    echo json_encode(["status" => "error", "message" => "Email already registered"]);
    exit();
}

// Generate UID (unique string)
$uid = uniqid("u_", true);

$hashed = password_hash($password, PASSWORD_DEFAULT);

$stmt = $conn->prepare("
    INSERT INTO users (uid, name, collegeId, email, password)
    VALUES (?, ?, ?, ?, ?)
");
$stmt->bind_param("sssss", $uid, $name, $collegeId, $email, $hashed);

if ($stmt->execute()) {
    echo json_encode(["status" => "success", "uid" => $uid]);
} else {
    echo json_encode(["status" => "error", "message" => "Failed to create account"]);
}

$stmt->close();
$conn->close();
?>
