<?php
header("Content-Type: application/json");
require 'db_config.php';

$id = $_POST['id'] ?? '';

if (empty($id)) {
    echo json_encode([
        "status" => "error",
        "message" => "Item ID required"
    ]);
    exit();
}

$stmt = $conn->prepare("DELETE FROM items WHERE id = ?");
$stmt->bind_param("i", $id);

if ($stmt->execute()) {
    echo json_encode(["status" => "success"]);
} else {
    echo json_encode([
        "status" => "error",
        "message" => "Delete failed"
    ]);
}

$stmt->close();
$conn->close();
?>
